/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.collections;

import java.util.*;

/**
 * Collection utility methods.
 *
 * @author Dawid Kurzyniec
 */
public class CollectionUtils {

    private CollectionUtils() {}

    /**
     * Returns the map wrapped so that it refers to the values via weak
     * references, thus not
     * keeping them from garbage collection. After a value becomes unreferenced
     * and collected, all the corresponding map entries are removed. (The cleanup
     * is not asynchronous but piggybacks on other map operations).
     * <p>
     * Iteration order of the returned wrapper map, and the overall performance
     * characterictics, are the same as those of the backing map.
     * <p>
     * It is required that the specified map is empty, and
     * that it is not used directly after this method returns.
     * <p>
     * Note: the values stored in this map keep strong references to their keys.
     * Therefore, using a WeakHashMap as a backing map will NOT yield a map
     * with both weak keys and weak values.
     */
    public Map weakValueMap(Map t) {
        return new WeakValueMap(t);
    }
}
